package gov.va.genisis2.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.dto.UserTypeDTO;
import gov.va.genisis2.model.UserType;

/**
 * This class is used to convert UserTypeDTO to UserType entity and vice-versa.
 * 
 * @author Prasad Thummalapalli
 *
 */
@Component
public class UserTypeConverter implements Converter<UserType, UserTypeDTO> {

	@Override
	public UserTypeDTO convert(UserType userType) {
		UserTypeDTO userTypeDto = new UserTypeDTO();

		userTypeDto.setUserTypeId(userType.getUserTypeId());
		userTypeDto.setUserTypeDesc(userType.getUserTypeDesc());

		return userTypeDto;
	}

	public UserType convert(UserTypeDTO userTypeDto) {
		UserType userType = new UserType();

		userType.setUserTypeId(userTypeDto.getUserTypeId());
		userType.setUserTypeDesc(userTypeDto.getUserTypeDesc());

		return userType;
	}
}